/*
 * Decompiled with CFR 0.152.
 */
package edu.greenriver.sdiv.myspringproject.service;

import edu.greenriver.sdiv.myspringproject.dbs.IUserRepository;
import edu.greenriver.sdiv.myspringproject.models.Permission;
import edu.greenriver.sdiv.myspringproject.models.User;
import java.util.ArrayList;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService
implements UserDetailsService {
    private IUserRepository repo;
    private PasswordEncoder passwordEncoder;

    public UserService(IUserRepository repo) {
        this.repo = repo;
        this.passwordEncoder = new BCryptPasswordEncoder();
    }

    public void saveUser(User newUser) {
        Permission userAuth = new Permission(0, "user", newUser);
        newUser.setPermissions(new ArrayList());
        newUser.getPermissions().add(userAuth);
        String encodedPassword = this.passwordEncoder.encode((CharSequence)newUser.getPassword());
        newUser.setPassword(encodedPassword);
        this.repo.save((Object)newUser);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.repo.findByUsername(username);
        if (user != null) {
            return user;
        }
        throw new UsernameNotFoundException("Username not found");
    }

    public String toString() {
        return "UserService{repo=" + this.repo + "}";
    }
}

