/*
 * Decompiled with CFR 0.152.
 */
package edu.greenriver.sdiv.myspringproject;

import edu.greenriver.sdiv.myspringproject.dbs.IResumeRepository;
import edu.greenriver.sdiv.myspringproject.dbs.IUserRepository;
import edu.greenriver.sdiv.myspringproject.models.Permission;
import edu.greenriver.sdiv.myspringproject.models.ResumeData;
import edu.greenriver.sdiv.myspringproject.models.User;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@SpringBootApplication
public class MySpringProjectApplication {
    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(MySpringProjectApplication.class, (String[])args);
        IResumeRepository repo = (IResumeRepository)context.getBean(IResumeRepository.class);
        IUserRepository userRepo = (IUserRepository)context.getBean(IUserRepository.class);
        BCryptPasswordEncoder encoder = (BCryptPasswordEncoder)context.getBean(BCryptPasswordEncoder.class);
        ResumeData[] education = new ResumeData[]{ResumeData.builder().activity("HighSchool").years("2013").graduated(true).subject("General").level("advance").build(), ResumeData.builder().activity("Associates").years("2018").graduated(true).subject("IT").level("basic").build(), ResumeData.builder().activity("Bachelor").years("2021").graduated(false).subject("Application Dev").level("intermediate").build(), ResumeData.builder().activity("Udemy").years("2021").graduated(false).subject("Spring Boot").level("intermediate").build(), ResumeData.builder().activity("Linkedin").years("2019").graduated(false).subject("Python").level("intermediate").build()};
        repo.saveAll(Arrays.asList(education));
        User admin = User.builder().username("admin").password(encoder.encode((CharSequence)"password")).build();
        Permission adminRole = new Permission(0, "admin", admin);
        admin.setPermissions(new ArrayList());
        admin.getPermissions().add(adminRole);
        userRepo.save((Object)admin);
        User user = User.builder().username("user").password(encoder.encode((CharSequence)"password")).build();
        Permission userRole = new Permission(0, "user", user);
        user.setPermissions(new ArrayList());
        user.getPermissions().add(userRole);
        userRepo.save((Object)user);
    }
}

