/*
 * Decompiled with CFR 0.152.
 */
package edu.greenriver.sdiv.myspringproject.service;

import edu.greenriver.sdiv.myspringproject.dbs.IResumeRepository;
import edu.greenriver.sdiv.myspringproject.models.ResumeData;
import java.util.List;
import java.util.NoSuchElementException;
import org.springframework.stereotype.Service;

@Service
public class ResumeService {
    private IResumeRepository repo;

    public ResumeService(IResumeRepository repo) {
        this.repo = repo;
    }

    public List<ResumeData> allData() {
        return this.repo.findAll();
    }

    public boolean dataExist(int id) {
        return this.byId(id) != null;
    }

    public ResumeData byId(int id) {
        return this.repo.findById(id).orElse(null);
    }

    public ResumeData saveData(ResumeData newData) {
        return (ResumeData)this.repo.save(newData);
    }

    public ResumeData editData(ResumeData data) {
        if (this.repo.findById(data.getId()).isEmpty()) {
            throw new NoSuchElementException("Missing Data...");
        }
        return (ResumeData)this.repo.save(data);
    }

    public void deleteRecord(int id) {
        this.repo.deleteById(id);
    }

    public String toString() {
        return "ResumeService{repo=" + this.repo + "}";
    }
}

